#include <bits/stdc++.h>
using namespace std;
typedef long long ll;
void DBG() { cerr << "]" << endl; }
template<class H, class... T> void DBG(H h, T... t) { cerr << to_string(h); if(sizeof...(t)) cerr << ", "; DBG(t...); }
#define dbg(...) cerr << "[" << #__VA_ARGS__ << "]: [", DBG(__VA_ARGS__)

#include <ext/pb_ds/assoc_container.hpp>
#include <ext/pb_ds/tree_policy.hpp>

using namespace __gnu_pbds;


typedef tree<pair<double,int>, null_type,
        less<pair<double,int>>, rb_tree_tag,
        tree_order_statistics_node_update>
        ordered_set_pair;

const int N = 2e5 + 3;
const int inf = 1e9;
const double EPS = 1e-5;
double x[N], v[N];

void solve() {
    int n; ll k; cin >> n >> k;
    for (int i = 1; i <= n; i++)
        cin >> x[i] >> v[i];

    ordered_set_pair st;

    double l = 0.0, r = 1e4;
    while (l + EPS < r) {
        double t = (l + r) / 2.0;
        ll preticanja = 0;
        st.clear();

        for (int i = n; i >= 1; i--) {
            double d = x[i] + t * v[i];
            ll pr = st.order_of_key({d, inf});
            st.insert({d, i});
            preticanja += pr;
        }
        if (preticanja >= k) {
            r = t;
        } else
            l = t;
    }

    cout << fixed << showpoint << setprecision(5) << r << "\n";
}

int main() {
    ios::sync_with_stdio(false); cin.tie(0);
    solve();
}